using System;
using System.Data;
using System.Collections;
using System.Text.RegularExpressions;
using System.Text;
using gov.va.med.vbecs.DAL;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.ExceptionManagement;
using Method = System.Reflection.MethodBase;
//
namespace gov.va.med.vbecs.BOL
{
    #region Medical device comment block
		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> 
		///WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified
		///</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<Note>
		///The Food and Drug Administration classifies this software as a medical device.  
		///As such, it may not be changed in any way. Modifications to this software may result 
		///in an adulterated medical device under 21CFR820, the use of which is considered to 
		///be a violation of US Federal Statutes.  Acquiring and implementing this software through 
		///the Freedom of information Act requires the implementor to assume total responsibility 
		///for the software, and become a registered manufacturer of a medical device, subject 
		///to FDA regulations
		///</Note>
		///<summary>
		///Create an instance of a ComponentClass reference object.
		///</summary>
    #endregion

    #region ComponentClass
    public class ComponentClass
    {
        private DataTable _componentClassDataTable;
        //
        private DataRow _componentClassDataRow;
        //
        //private ComponentClass[] _compatibleComponents;
        //	

        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7121"> 
		///		<ExpectedInput>Valid component class ID (1-6)</ExpectedInput>
		///		<ExpectedOutput>component class created</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7122"> 
		///		<ExpectedInput>Invalid component class ID (0)</ExpectedInput>
		///		<ExpectedOutput>Data Access Layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Create an instance of ComponentClass based on its "ComponentClassId".
        /// </summary>
        public ComponentClass(int  componentClassID)
        {
            GetComponentClassData(componentClassID);
        }

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/18/2005</CreationDate>
		///
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// LoadFromDataRow
        /// </summary>
        /// <param name="dataRow"></param>
        protected void LoadFromDataRow(DataRow dataRow)
        {
            _componentClassDataTable = dataRow.Table;
            _componentClassDataRow = dataRow;
        }


		/// <summary>
		/// GetComponentClassData
		/// </summary>
		/// <param name="componentClassID"></param>
        private void GetComponentClassData(int componentClassID)
        {
            LoadFromDataRow(DAL.ReferenceData.GetComponentClass(componentClassID));
        }


		#region Public Properties
        //
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
        ///	
		///<TestCases>
		///	
		///<Case type="0" testid ="7125"> 
		///		<ExpectedInput>Valid component class object</ExpectedInput>
		///		<ExpectedOutput>Component class ID property</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7126"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// int value containing the component class Id
        /// </summary>
        public int ComponentClassId
        {
			
            get 
            {
                return (int)_componentClassDataRow[Common.VbecsTables.ComponentClass.ComponentClassId];
            }
        }
        	
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
        ///	
		///<TestCases>
		///	
		///<Case type="0" testid ="7127"> 
		///		<ExpectedInput>Valid component class object</ExpectedInput>
		///		<ExpectedOutput>Component class short name property</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7128"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// string value containing the component class short name
        /// </summary>
        public string ComponentClassShortName
        {
			
            get 
            {
                return (string)_componentClassDataRow[Common.VbecsTables.ComponentClass.ComponentClassShortName];
            }
        }
        
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
        ///
		///<TestCases>
		///	
		///<Case type="0" testid ="7129"> 
		///		<ExpectedInput>Valid component class object</ExpectedInput>
		///		<ExpectedOutput>Component class name property</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7130"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// string value containing the name
        /// </summary>
        public string Name
        {
			
            get 
            {
                return (string)_componentClassDataRow[Common.VbecsTables.ComponentClass.ComponentClassName];
            }
        }
        
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
        ///
		///<TestCases>
		///	
		///<Case type="0" testid ="7131"> 
		///		<ExpectedInput>Valid component class object</ExpectedInput>
		///		<ExpectedOutput>cprs orderable item id property</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7132"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// string value containing the cprs orderable item Id
        /// </summary>
        public string CprsOrderableItemId
        {
			
            get 
            {
                return (string)_componentClassDataRow[Common.VbecsTables.ComponentClass.CprsOrderableItemId];
            }
        }
        
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
        ///
		///<TestCases>
		///	
		///<Case type="0" testid ="7133"> 
		///		<ExpectedInput>Valid component class object</ExpectedInput>
		///		<ExpectedOutput>Component class sort column property</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7134"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// short value containing the sort column
        /// </summary>
        public short SortColumn
        {
			
            get 
            {
                return (short)_componentClassDataRow[Common.VbecsTables.ComponentClass.SortColumn];
            }
        }
        
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
        ///
		///<TestCases>
		///	
		///<Case type="0" testid ="7135"> 
		///		<ExpectedInput>Valid component class object</ExpectedInput>
		///		<ExpectedOutput>Component class last update date property</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7136"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// DateTime value containing the last update date
        /// </summary>
        public DateTime LastUpdateDate
        {
			
            get 
            {
                return (DateTime)_componentClassDataRow[Common.VbecsTables.ComponentClass.LastUpdateDate];
            }
        }
        
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
        ///
		///<TestCases>
		///	
		///<Case type="0" testid ="7137"> 
		///		<ExpectedInput>Valid component class object</ExpectedInput>
		///		<ExpectedOutput>Component class last update user property</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7138"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// string value containing the last update user
        /// </summary>
        public string LastUpdateUser
        {
			
            get 
            {
                return (string)_componentClassDataRow[Common.VbecsTables.ComponentClass.LastUpdateUser];
            }
        }
        
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
        ///
		///<TestCases>
		///	
		///<Case type="0" testid ="7139"> 
		///		<ExpectedInput>Valid component class object</ExpectedInput>
		///		<ExpectedOutput>Component class row version property</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7140"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// timestamp value containing the row version
        /// </summary>
        public byte[] RowVersion
        {
			
            get 
            {
                return (byte[])_componentClassDataRow[Common.VbecsTables.ComponentClass.RowVersion];
            }
        }
				
        //
		#endregion

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7141"> 
		///		<ExpectedInput>Valid component class ID (1-6)</ExpectedInput>
		///		<ExpectedOutput>component class created</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7142"> 
		///		<ExpectedInput>Invalid component class ID (0)</ExpectedInput>
		///		<ExpectedOutput>Data Access Layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns a component class based on component class ID
		/// </summary>
		/// <param name="componentClassID"></param>
		/// <returns></returns>
        public static ComponentClass GetComponentClass(int componentClassID)
        {
            return new ComponentClass(componentClassID);
        }
    }
	#endregion
}
